﻿/*
 * FastPWM_.c
 *
 * Created: 2014/06/07 23:32:27
 *  Author: Hirosi
 */ 

#include <avr/io.h>
#include "SettingFastPWM.h"

/*     AVRwiki より拝借マクロ
    cbi()    addrのbit番目をLowに
    sbi()    addrのbit番目をHighに    */
#define cbi(addr,bit)     addr &= ~(1<<bit)
#define sbi(addr,bit)     addr |=  (1<<bit)

void FastPWMStart()
{
	// タイマ0レジスタ設定
	TCCR0A = (Set_COM0A << 6) | (Set_COM0B << 4) | (Set_WGM0 & 0x03);
	TCCR0B = ((Set_WGM0 & 0x04) << 1) | Set_CS0;
	
	// タイマ2レジスタ設定
	TCCR2A = (Set_COM2A << 6) | (Set_COM2B << 4) | (Set_WGM2 & 0x03);
	TCCR2B = ((Set_WGM2 & 0x04) << 1) | Set_CS2;
	
	// I/Oの設定
	if (Set_COM0A)
		sbi(OC0A_DDR,OCR0A_Num);
	if (Set_COM0B)
		sbi(OC0B_DDR,OCR0B_Num);
	if (Set_COM2A)
		sbi(OC2A_DDR,OCR2A_Num);
	if (Set_COM2B)
		sbi(OC2B_DDR,OCR2B_Num);
}